/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sf.picard.PicardException;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class ProcessExecutor {
    private static final Log log = Log.getInstance(ProcessExecutor.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ProcessExecutor Thread");
        }
    });

    public static int execute(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable t) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", command) + "]", t);
        }
    }

    public static int execute(String[] commandParts) {
        return ProcessExecutor.execute(commandParts, null);
    }

    public static int execute(String[] commandParts, String outputStreamString) {
        try {
            Process process = Runtime.getRuntime().exec(commandParts);
            if (outputStreamString != null) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                writer.write(outputStreamString);
                writer.newLine();
                writer.close();
            }
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable t) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", commandParts) + "]", t);
        }
    }

    public static String executeAndReturnResult(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            StringBuilderProcessOutputReader err = new StringBuilderProcessOutputReader(process.getErrorStream());
            Future<?> stderrReader = executorService.submit(err);
            StringBuilderProcessOutputReader stdout = new StringBuilderProcessOutputReader(process.getInputStream());
            stdout.run();
            stderrReader.get();
            int result = process.waitFor();
            return result == 0 ? stdout.getOutput() : err.getOutput();
        }
        catch (Throwable t) {
            throw new PicardException("Unexpected exception executing [" + command + "]", t);
        }
    }

    private static int readStreamsAndWaitFor(Process process) throws InterruptedException, ExecutionException {
        Future<?> stderrReader = executorService.submit(new LogErrorProcessOutputReader(process.getErrorStream()));
        new LogInfoProcessOutputReader(process.getInputStream()).run();
        stderrReader.get();
        return process.waitFor();
    }

    private static class LogErrorProcessOutputReader
    extends ProcessOutputReader {
        public LogErrorProcessOutputReader(InputStream stream) {
            super(stream);
        }

        @Override
        protected void write(String message) {
            log.error(message);
        }
    }

    private static class LogInfoProcessOutputReader
    extends ProcessOutputReader {
        public LogInfoProcessOutputReader(InputStream stream) {
            super(stream);
        }

        @Override
        protected void write(String message) {
            log.info(message);
        }
    }

    private static abstract class ProcessOutputReader
    implements Runnable {
        private final BufferedReader reader;

        public ProcessOutputReader(InputStream stream) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.write(line);
                }
            }
            catch (IOException e) {
                throw new PicardException("Unexpected exception reading from process stream", e);
            }
        }

        protected abstract void write(String var1);
    }

    private static class StringBuilderProcessOutputReader
    extends ProcessOutputReader {
        private final StringBuilder sb = new StringBuilder();

        public StringBuilderProcessOutputReader(InputStream stream) {
            super(stream);
        }

        @Override
        protected void write(String message) {
            this.sb.append(message).append("\n");
        }

        public String getOutput() {
            return this.sb.toString();
        }
    }
}

