/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public final class QualityUtil {
    private static final double[] errorProbabilityByPhredScore = new double[101];

    static {
        int i = 0;
        while (i < errorProbabilityByPhredScore.length) {
            QualityUtil.errorProbabilityByPhredScore[i] = 1.0 / Math.pow(10.0, (double)i / 10.0);
            ++i;
        }
    }

    public static double getErrorProbabilityFromPhredScore(int i) {
        return errorProbabilityByPhredScore[i];
    }

    public static int getPhredScoreFromErrorProbability(double probability) {
        return (int)Math.round(-10.0 * Math.log10(probability));
    }

    public static int getPhredScoreFromObsAndErrors(double observations, double errors) {
        return QualityUtil.getPhredScoreFromErrorProbability(errors / observations);
    }

    public static double sumOfErrorProbabilities(SAMRecord rec) {
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        double sum = 0.0;
        int i = 0;
        while (i < bases.length) {
            sum = SequenceUtil.isNoCall(bases[i]) ? (sum += 1.0) : (sum += QualityUtil.getErrorProbabilityFromPhredScore(quals[i]));
            ++i;
        }
        return sum;
    }
}

