/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTagUtil;
import net.sf.samtools.SQTagUtil;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class SAMRecordUtil {
    private static final short[] STRING_TAGS_TO_REVERSE = new short[]{SAMTagUtil.getSingleton().U2, SAMTagUtil.getSingleton().OQ};

    public static void reverseComplement(SAMRecord rec) {
        String e2TagValue;
        byte[] readBases = rec.getReadBases();
        SequenceUtil.reverseComplement(readBases);
        rec.setReadBases(readBases);
        byte[] qualities = rec.getBaseQualities();
        SAMRecordUtil.reverseArray(qualities);
        rec.setBaseQualities(qualities);
        byte[] sqTagValue = (byte[])rec.getAttribute(SAMTagUtil.getSingleton().SQ);
        if (sqTagValue != null) {
            SQTagUtil.reverseComplementSqArray(sqTagValue);
            rec.setAttribute(SAMTagUtil.getSingleton().SQ, (Object)sqTagValue);
        }
        if ((e2TagValue = (String)rec.getAttribute(SAMTagUtil.getSingleton().E2)) != null) {
            byte[] secondaryBases = StringUtil.stringToBytes(e2TagValue);
            SequenceUtil.reverseComplement(secondaryBases);
            rec.setAttribute(SAMTagUtil.getSingleton().E2, (Object)StringUtil.bytesToString(secondaryBases));
        }
        short[] sArray = STRING_TAGS_TO_REVERSE;
        int n = STRING_TAGS_TO_REVERSE.length;
        int n2 = 0;
        while (n2 < n) {
            short stringTag = sArray[n2];
            String value = (String)rec.getAttribute(stringTag);
            if (value != null) {
                rec.setAttribute(stringTag, (Object)StringUtil.reverseString(value));
            }
            ++n2;
        }
    }

    public static void reverseArray(byte[] array) {
        int lastIndex = array.length - 1;
        int i = 0;
        int j = lastIndex;
        while (i < j) {
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }
}

