/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.BlockCompressedStreamConstants;

public class BlockCompressedOutputStream
extends OutputStream {
    private static int defaultCompressionLevel = BlockCompressedStreamConstants.DEFAULT_COMPRESSION_LEVEL;
    private final BinaryCodec codec;
    private final byte[] uncompressedBuffer = new byte[65498];
    private int numUncompressedBytes = 0;
    private final byte[] compressedBuffer = new byte[65518];
    private final Deflater deflater;
    private final Deflater noCompressionDeflater = new Deflater(0, true);
    private final CRC32 crc32 = new CRC32();
    private File file = null;
    private long mBlockAddress = 0L;
    private final byte[] singleByteArray = new byte[1];

    public static void setDefaultCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
        defaultCompressionLevel = compressionLevel;
    }

    public static int getDefaultCompressionLevel() {
        return defaultCompressionLevel;
    }

    public BlockCompressedOutputStream(String filename) {
        this(filename, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(File file) {
        this(file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(String filename, int compressionLevel) {
        this(new File(filename), compressionLevel);
    }

    public BlockCompressedOutputStream(File file, int compressionLevel) {
        this.file = file;
        this.codec = new BinaryCodec(file, true);
        this.deflater = new Deflater(compressionLevel, true);
    }

    public BlockCompressedOutputStream(OutputStream os, File file) {
        this(os, file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(OutputStream os, File file, int compressionLevel) {
        this.file = file;
        this.codec = new BinaryCodec(os);
        if (file != null) {
            this.codec.setOutputFileName(file.getAbsolutePath());
        }
        this.deflater = new Deflater(compressionLevel, true);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(byte[] bytes, int startIndex, int numBytes) throws IOException {
        if (BlockCompressedOutputStream.$assertionsDisabled || this.numUncompressedBytes < this.uncompressedBuffer.length) ** GOTO lbl12
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            bytesToWrite = Math.min(this.uncompressedBuffer.length - this.numUncompressedBytes, numBytes);
            System.arraycopy(bytes, startIndex, this.uncompressedBuffer, this.numUncompressedBytes, bytesToWrite);
            this.numUncompressedBytes += bytesToWrite;
            startIndex += bytesToWrite;
            if (!BlockCompressedOutputStream.$assertionsDisabled && (numBytes -= bytesToWrite) < 0) {
                throw new AssertionError();
            }
            if (this.numUncompressedBytes != this.uncompressedBuffer.length) continue;
            this.deflateBlock();
lbl12:
            // 3 sources

            ** while (numBytes > 0)
        }
lbl13:
        // 1 sources

    }

    @Override
    public void flush() throws IOException {
        while (this.numUncompressedBytes > 0) {
            this.deflateBlock();
        }
        this.codec.getOutputStream().flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.codec.writeBytes(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        this.codec.close();
        if (this.file == null || !this.file.isFile()) {
            return;
        }
        if (BlockCompressedInputStream.checkTermination(this.file) != BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK) {
            throw new IOException("Terminator block not found after closing BGZF file " + this.file);
        }
    }

    @Override
    public void write(int bite) throws IOException {
        this.singleByteArray[0] = (byte)bite;
        this.write(this.singleByteArray);
    }

    public long getFilePointer() {
        return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress, this.numUncompressedBytes);
    }

    private int deflateBlock() {
        if (this.numUncompressedBytes == 0) {
            return 0;
        }
        int bytesToCompress = this.numUncompressedBytes;
        this.deflater.reset();
        this.deflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
        this.deflater.finish();
        int compressedSize = this.deflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
        if (!this.deflater.finished()) {
            this.noCompressionDeflater.reset();
            this.noCompressionDeflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
            this.noCompressionDeflater.finish();
            compressedSize = this.noCompressionDeflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
            if (!this.noCompressionDeflater.finished()) {
                throw new IllegalStateException("unpossible");
            }
        }
        this.crc32.reset();
        this.crc32.update(this.uncompressedBuffer, 0, bytesToCompress);
        int totalBlockSize = this.writeGzipBlock(compressedSize, bytesToCompress, this.crc32.getValue());
        assert (bytesToCompress <= this.numUncompressedBytes);
        if (bytesToCompress == this.numUncompressedBytes) {
            this.numUncompressedBytes = 0;
        } else {
            System.arraycopy(this.uncompressedBuffer, bytesToCompress, this.uncompressedBuffer, 0, this.numUncompressedBytes - bytesToCompress);
            this.numUncompressedBytes -= bytesToCompress;
        }
        this.mBlockAddress += (long)totalBlockSize;
        return totalBlockSize;
    }

    private int writeGzipBlock(int compressedSize, int uncompressedSize, long crc) {
        this.codec.writeByte((byte)31);
        this.codec.writeByte(139);
        this.codec.writeByte((byte)8);
        this.codec.writeByte(4);
        this.codec.writeInt(0);
        this.codec.writeByte(0);
        this.codec.writeByte(255);
        this.codec.writeShort((short)6);
        this.codec.writeByte((byte)66);
        this.codec.writeByte((byte)67);
        this.codec.writeShort((short)2);
        int totalBlockSize = compressedSize + 18 + 8;
        this.codec.writeShort((short)(totalBlockSize - 1));
        this.codec.writeBytes(this.compressedBuffer, 0, compressedSize);
        this.codec.writeInt((int)crc);
        this.codec.writeInt(uncompressedSize);
        return totalBlockSize;
    }
}

