/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sf.samtools.SAMException;

public class Md5CalculatingOutputStream
extends OutputStream {
    private final OutputStream os;
    private final MessageDigest md5;
    private final File digestFile;
    private String hash = null;

    public Md5CalculatingOutputStream(OutputStream os, File digestFile) {
        this.os = os;
        this.digestFile = digestFile;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.md5.reset();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found", e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.md5.update((byte)b);
        this.os.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.md5.update(b);
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.md5.update(b, off, len);
        this.os.write(b, off, len);
    }

    public String md5() {
        if (this.hash == null) {
            throw new SAMException("Attempting to access md5 digest before the entire file is written!  Call close first.");
        }
        return this.hash;
    }

    private String makeHash() {
        if (this.hash == null) {
            this.hash = new BigInteger(1, this.md5.digest()).toString(16);
            if (this.hash.length() != 32) {
                String zeros = "00000000000000000000000000000000";
                this.hash = String.valueOf("00000000000000000000000000000000".substring(0, 32 - this.hash.length())) + this.hash;
            }
            return this.hash;
        }
        throw new SAMException("Calling close on Md5CalculatingOutputStream twice!");
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.makeHash();
        if (this.digestFile != null) {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.digestFile));
            writer.write(this.hash);
            writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }
}

