/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.compound;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biojava3.core.sequence.template.AbstractCompound;
import org.biojava3.core.sequence.template.ComplementCompound;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;

public class NucleotideCompound
extends AbstractCompound
implements ComplementCompound {
    private final CompoundSet<NucleotideCompound> compoundSet;
    private final String complementStr;
    private final Set<NucleotideCompound> constituents;

    public NucleotideCompound(String base, CompoundSet<NucleotideCompound> compoundSet, String complementStr) {
        super(base);
        this.compoundSet = compoundSet;
        this.complementStr = complementStr;
        this.constituents = Collections.unmodifiableSet(new HashSet<NucleotideCompound>(Arrays.asList(this)));
    }

    public NucleotideCompound(String base, CompoundSet<NucleotideCompound> compoundSet, String complementStr, NucleotideCompound[] constituents) {
        super(base);
        this.compoundSet = compoundSet;
        this.complementStr = complementStr;
        this.constituents = Collections.unmodifiableSet(new HashSet<NucleotideCompound>(Arrays.asList(constituents)));
    }

    @Override
    public String getShortName() {
        return this.getBase();
    }

    @Override
    public ComplementCompound getComplement() {
        return this.compoundSet.getCompoundForString(this.complementStr);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NucleotideCompound)) {
            return false;
        }
        NucleotideCompound them = (NucleotideCompound)obj;
        return this.toString().equals(them.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equalsIgnoreCase(Compound compound) {
        if (compound == null) {
            return false;
        }
        if (!(compound instanceof NucleotideCompound)) {
            return false;
        }
        NucleotideCompound them = (NucleotideCompound)compound;
        return this.toString().equalsIgnoreCase(them.toString());
    }

    public Set<NucleotideCompound> getConsituents() {
        return this.constituents;
    }

    public boolean isAmbiguous() {
        return !this.constituents.isEmpty();
    }
}

