/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.io.BufferedReaderBytesRead;
import org.biojava3.core.sequence.io.FileProxyProteinSequenceCreator;
import org.biojava3.core.sequence.io.GenericFastaHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.io.template.FastaHeaderParserInterface;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class FastaReader<S extends Sequence<?>, C extends Compound> {
    SequenceCreatorInterface<C> sequenceCreator;
    FastaHeaderParserInterface<S, C> headerParser;
    BufferedReaderBytesRead br;
    InputStreamReader isr;
    FileInputStream fi = null;

    public FastaReader(InputStream is, FastaHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) {
        this.headerParser = headerParser;
        this.isr = new InputStreamReader(is);
        this.br = new BufferedReaderBytesRead(this.isr);
        this.sequenceCreator = sequenceCreator;
    }

    public FastaReader(File file, FastaHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) throws FileNotFoundException {
        this.headerParser = headerParser;
        this.fi = new FileInputStream(file);
        this.isr = new InputStreamReader(this.fi);
        this.br = new BufferedReaderBytesRead(this.isr);
        this.sequenceCreator = sequenceCreator;
    }

    public LinkedHashMap<String, S> process() throws IOException {
        LinkedHashMap<String, AbstractSequence<C>> sequences = new LinkedHashMap<String, AbstractSequence<C>>();
        String line = "";
        String header = "";
        StringBuilder sb = new StringBuilder();
        int maxSequenceLength = -1;
        long fileIndex = 0L;
        long sequenceIndex = 0L;
        boolean keepGoing = true;
        do {
            AbstractSequence<C> sequence;
            if ((line = line.trim()).length() != 0) {
                if (line.startsWith(">")) {
                    if (sb.length() > 0) {
                        sequence = this.sequenceCreator.getSequence(sb.toString(), sequenceIndex);
                        this.headerParser.parseHeader(header, sequence);
                        sequences.put(sequence.getAccession().getID(), sequence);
                        if (maxSequenceLength < sb.length()) {
                            maxSequenceLength = sb.length();
                        }
                        sb = new StringBuilder(maxSequenceLength);
                    }
                    header = line.substring(1);
                } else if (!line.startsWith(";")) {
                    if (sb.length() == 0) {
                        sequenceIndex = fileIndex;
                    }
                    sb.append(line);
                }
            }
            fileIndex = this.br.getBytesRead();
            line = this.br.readLine();
            if (line != null) continue;
            sequence = this.sequenceCreator.getSequence(sb.toString(), sequenceIndex);
            this.headerParser.parseHeader(header, sequence);
            sequences.put(sequence.getAccession().getID(), sequence);
            keepGoing = false;
        } while (keepGoing);
        this.br.close();
        this.isr.close();
        if (this.fi != null) {
            this.fi.close();
        }
        return sequences;
    }

    public static void main(String[] args) {
        try {
            String inputFile = "src/test/resources/PF00104_small.fasta";
            FileInputStream is = new FileInputStream(inputFile);
            FastaReader fastaReader = new FastaReader(is, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            is.close();
            System.out.println(proteinSequences);
            File file = new File(inputFile);
            FastaReader fastaProxyReader = new FastaReader(file, new GenericFastaHeaderParser(), new FileProxyProteinSequenceCreator(file, AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinProxySequences = fastaProxyReader.process();
            for (String key : proteinProxySequences.keySet()) {
                ProteinSequence proteinSequence = (ProteinSequence)proteinProxySequences.get(key);
                System.out.println(key);
                System.out.println(proteinSequence.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

