/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.loader;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.biojava3.core.exceptions.CompoundNotFoundError;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.DataSource;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.features.DBReferenceInfo;
import org.biojava3.core.sequence.features.DatabaseReferenceInterface;
import org.biojava3.core.sequence.features.FeaturesKeyWordInterface;
import org.biojava3.core.sequence.storage.SequenceAsStringHelper;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceView;
import org.biojava3.core.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UniprotProxySequenceReader<C extends Compound>
implements ProxySequenceReader<C>,
FeaturesKeyWordInterface,
DatabaseReferenceInterface {
    private static final Logger logger = Logger.getLogger(UniprotProxySequenceReader.class.getName());
    private static String uniprotbaseURL = "http://www.uniprot.org";
    private static String uniprotDirectoryCache = null;
    private String sequence;
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();
    Document uniprotDoc;

    public UniprotProxySequenceReader(String accession, CompoundSet<C> compoundSet) throws Exception {
        this.setCompoundSet(compoundSet);
        this.uniprotDoc = this.getUniprotXML(accession);
        String seq = this.getSequence(this.uniprotDoc);
        this.setContents(seq);
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public void setContents(String sequence) {
        this.sequence = sequence;
        this.parsedCompounds.clear();
        int i = 0;
        while (i < sequence.length()) {
            String compoundStr = null;
            Object compound = null;
            int compoundStrLength = 1;
            while (compound == null && compoundStrLength <= this.compoundSet.getMaxSingleCompoundStringLength()) {
                compoundStr = sequence.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
                ++compoundStrLength;
            }
            if (compound == null) {
                throw new CompoundNotFoundError((CharSequence)compoundStr);
            }
            i += compoundStr.length();
            this.parsedCompounds.add(compound);
        }
    }

    @Override
    public int getLength() {
        return this.parsedCompounds.size();
    }

    @Override
    public C getCompoundAt(int position) {
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return this.sequence;
    }

    @Override
    public List<C> getAsList() {
        return this.parsedCompounds;
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }

    public String getSequenceAsString(Integer bioBegin, Integer bioEnd, Strand strand) {
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, bioBegin, bioEnd, strand);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return this.parsedCompounds.iterator();
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public AccessionID getAccession() {
        AccessionID accessionID = new AccessionID();
        if (this.uniprotDoc == null) {
            return accessionID;
        }
        try {
            Element uniprotElement = this.uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            Element nameElement = XMLHelper.selectSingleElement(entryElement, "name");
            accessionID = new AccessionID(nameElement.getTextContent(), DataSource.UNIPROT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accessionID;
    }

    @Override
    public int countCompounds(C ... compounds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Document getUniprotXML(String accession) throws Exception {
        int index = accession.lastIndexOf(".");
        String key = accession;
        if (index != -1) {
            key = accession.substring(0, index);
        }
        StringBuilder sb = new StringBuilder();
        File f = null;
        if (uniprotDirectoryCache != null && uniprotDirectoryCache.length() > 0 && (f = new File(String.valueOf(uniprotDirectoryCache) + File.separatorChar + key + ".xml")).exists()) {
            FileReader fr = new FileReader(f);
            int size = (int)f.length();
            char[] data = new char[size];
            fr.read(data);
            fr.close();
            sb.append(data);
            index = sb.indexOf("xmlns=");
            if (index != -1) {
                int lastIndex = sb.indexOf(">", index);
                sb.replace(index, lastIndex, "");
            }
        }
        if (sb.length() == 0) {
            String inputLine;
            String uniprotURL = String.valueOf(UniprotProxySequenceReader.getUniprotbaseURL()) + "/uniprot/?query=" + key + "&format=xml";
            logger.info("Loading " + uniprotURL);
            URL uniprot = new URL(uniprotURL);
            URLConnection uniprotConnection = uniprot.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(uniprotConnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            index = sb.indexOf("xmlns=");
            if (index != -1) {
                int lastIndex = sb.indexOf(">", index);
                sb.replace(index, lastIndex, "");
            }
            if (f != null) {
                FileWriter fw = new FileWriter(f);
                fw.write(sb.toString());
                fw.close();
            }
        }
        logger.info("Load complete");
        try {
            Document document = XMLHelper.inputStreamToDocument(new ByteArrayInputStream(sb.toString().getBytes()));
            return document;
        }
        catch (Exception e) {
            System.out.println("Exception on xml parse of:" + sb.toString());
            return null;
        }
    }

    private String getSequence(Document uniprotDoc) throws Exception {
        Element uniprotElement = uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        Element sequenceElement = XMLHelper.selectSingleElement(entryElement, "sequence");
        String seqdata = sequenceElement.getTextContent();
        return seqdata;
    }

    public static String getUniprotbaseURL() {
        return uniprotbaseURL;
    }

    public static void setUniprotbaseURL(String aUniprotbaseURL) {
        uniprotbaseURL = aUniprotbaseURL;
    }

    public static String getUniprotDirectoryCache() {
        return uniprotDirectoryCache;
    }

    public static void setUniprotDirectoryCache(String aUniprotDirectoryCache) {
        File f = new File(aUniprotDirectoryCache);
        if (!f.exists()) {
            f.mkdirs();
        }
        uniprotDirectoryCache = aUniprotDirectoryCache;
    }

    public static void main(String[] args) {
        try {
            UniprotProxySequenceReader<AminoAcidCompound> uniprotSequence = new UniprotProxySequenceReader<AminoAcidCompound>("YA745_GIBZE", AminoAcidCompoundSet.getAminoAcidCompoundSet());
            ProteinSequence proteinSequence = new ProteinSequence(uniprotSequence);
            System.out.println(proteinSequence.getAccession().getID());
            System.out.println("Sequence=" + proteinSequence.getSequenceAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getGeneName() throws Exception {
        if (this.uniprotDoc == null) {
            return "";
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        Element geneElement = XMLHelper.selectSingleElement(entryElement, "gene");
        if (geneElement == null) {
            return "";
        }
        Element nameElement = XMLHelper.selectSingleElement(geneElement, "name");
        if (nameElement == null) {
            return "";
        }
        return nameElement.getTextContent();
    }

    public String getOrganismName() throws Exception {
        if (this.uniprotDoc == null) {
            return "";
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        Element organismElement = XMLHelper.selectSingleElement(entryElement, "organism");
        if (organismElement == null) {
            return "";
        }
        Element nameElement = XMLHelper.selectSingleElement(organismElement, "name");
        if (nameElement == null) {
            return "";
        }
        return nameElement.getTextContent();
    }

    @Override
    public ArrayList<String> getKeyWords() throws Exception {
        ArrayList<String> keyWordsList = new ArrayList<String>();
        if (this.uniprotDoc == null) {
            return keyWordsList;
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        ArrayList<Element> keyWordElementList = XMLHelper.selectElements(entryElement, "keyword");
        for (Element element : keyWordElementList) {
            keyWordsList.add(element.getTextContent());
        }
        return keyWordsList;
    }

    @Override
    public LinkedHashMap<String, ArrayList<DBReferenceInfo>> getDatabaseReferences() throws Exception {
        LinkedHashMap<String, ArrayList<DBReferenceInfo>> databaseReferencesHashMap = new LinkedHashMap<String, ArrayList<DBReferenceInfo>>();
        if (this.uniprotDoc == null) {
            return databaseReferencesHashMap;
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        ArrayList<Element> dbreferenceElementList = XMLHelper.selectElements(entryElement, "dbReference");
        for (Element element : dbreferenceElementList) {
            String type = element.getAttribute("type");
            String id = element.getAttribute("id");
            ArrayList<DBReferenceInfo> idlist = databaseReferencesHashMap.get(type);
            if (idlist == null) {
                idlist = new ArrayList();
                databaseReferencesHashMap.put(type, idlist);
            }
            DBReferenceInfo dbreferenceInfo = new DBReferenceInfo(type, id);
            ArrayList<Element> propertyElementList = XMLHelper.selectElements(element, "property");
            for (Element propertyElement : propertyElementList) {
                String propertyType = propertyElement.getAttribute("type");
                String propertyValue = propertyElement.getAttribute("value");
                dbreferenceInfo.addProperty(propertyType, propertyValue);
            }
            idlist.add(dbreferenceInfo);
        }
        return databaseReferencesHashMap;
    }
}

