/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.List;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;

public class SequenceAsStringHelper<C extends Compound> {
    public String getSequenceAsString(List<C> parsedCompounds, CompoundSet<C> compoundSet, Integer bioBegin, Integer bioEnd, Strand strand) {
        if (parsedCompounds.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (strand.equals((Object)Strand.NEGATIVE)) {
            if (bioBegin <= bioEnd) {
                int index = bioEnd - 1;
                while (index >= bioBegin - 1) {
                    Compound compound = (Compound)parsedCompounds.get(index);
                    builder.append(compoundSet.getStringForCompound(compound));
                    --index;
                }
            } else {
                Compound compound;
                int index = bioBegin - 1;
                while (index >= 0) {
                    compound = (Compound)parsedCompounds.get(index);
                    builder.append(compoundSet.getStringForCompound(compound));
                    --index;
                }
                index = parsedCompounds.size() - 1;
                while (index >= bioEnd - 1) {
                    compound = (Compound)parsedCompounds.get(index);
                    builder.append(compoundSet.getStringForCompound(compound));
                    --index;
                }
            }
        } else if (bioBegin <= bioEnd) {
            int index = bioBegin - 1;
            while (index <= bioEnd - 1) {
                Compound compound = (Compound)parsedCompounds.get(index);
                builder.append(compoundSet.getStringForCompound(compound));
                ++index;
            }
        } else {
            Compound compound;
            int index = bioBegin - 1;
            while (index <= parsedCompounds.size() - 1) {
                compound = (Compound)parsedCompounds.get(index);
                builder.append(compoundSet.getStringForCompound(compound));
                ++index;
            }
            index = 0;
            while (index <= bioEnd - 1) {
                compound = (Compound)parsedCompounds.get(index);
                builder.append(compoundSet.getStringForCompound(compound));
                ++index;
            }
        }
        return builder.toString();
    }
}

