/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava3.core.exceptions.TranslationException;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.CompoundTranslator;
import org.biojava3.core.sequence.template.Sequence;

public abstract class AbstractCompoundTranslator<F extends Compound, T extends Compound>
implements CompoundTranslator<F, T> {
    private final SequenceCreatorInterface<T> creator;
    private final Map<F, List<T>> mapper;
    private final CompoundSet<F> fromCompoundSet;
    private final CompoundSet<T> toCompoundSet;

    public AbstractCompoundTranslator(SequenceCreatorInterface<T> creator, CompoundSet<F> fromCompoundSet, CompoundSet<T> toCompoundSet) {
        this.creator = creator;
        this.mapper = new HashMap<F, List<T>>();
        this.fromCompoundSet = fromCompoundSet;
        this.toCompoundSet = toCompoundSet;
    }

    public SequenceCreatorInterface<T> getCreator() {
        return this.creator;
    }

    public CompoundSet<F> getFromCompoundSet() {
        return this.fromCompoundSet;
    }

    public CompoundSet<T> getToCompoundSet() {
        return this.toCompoundSet;
    }

    protected void addStrings(String source, String ... targets) {
        F f = this.getFromCompoundSet().getCompoundForString(source);
        String[] stringArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            this.addCompounds((Compound)f, new Compound[]{this.getToCompoundSet().getCompoundForString(t)});
            ++n2;
        }
    }

    protected void addCompounds(F source, T ... targets) {
        List<T> l = this.mapper.get(source);
        if (l == null) {
            l = new ArrayList<T>();
            this.mapper.put(source, l);
        }
        l.addAll(Arrays.asList(targets));
    }

    @Override
    public List<T> translateMany(F fromCompound) {
        return this.mapper.get(fromCompound);
    }

    @Override
    public T translate(F fromCompound) {
        List<T> compounds = this.translateMany(fromCompound);
        if (compounds.isEmpty()) {
            throw new TranslationException("No compounds found for " + fromCompound);
        }
        if (compounds.size() > 1) {
            throw new TranslationException("Too many compounds found for " + fromCompound);
        }
        return (T)((Compound)compounds.get(0));
    }

    @Override
    public List<Sequence<T>> createSequences(Sequence<F> originalSequence) {
        ArrayList<List<T>> workingList = new ArrayList<List<T>>();
        for (Compound source : originalSequence) {
            List<T> compounds = this.translateMany(source);
            if (compounds.isEmpty()) {
                throw new TranslationException("Compound " + source + " resulted in " + "no target compounds");
            }
            this.addCompoundsToList(compounds, workingList);
        }
        this.postProcessCompoundLists(workingList);
        return this.workingListToSequences(workingList);
    }

    protected abstract void postProcessCompoundLists(List<List<T>> var1);

    protected void addCompoundsToList(List<T> compounds, List<List<T>> workingList) {
        int size = compounds.size();
        ArrayList<List<T>> currentWorkingList = new ArrayList<List<T>>();
        int i = 0;
        while (i < size) {
            boolean last;
            boolean bl = last = i == size - 1;
            if (last) {
                this.addCompoundToLists(workingList, (Compound)compounds.get(i));
                if (!currentWorkingList.isEmpty()) {
                    workingList.addAll(currentWorkingList);
                }
            } else {
                List<List<T>> duplicate = this.duplicateList(workingList);
                this.addCompoundToLists(duplicate, (Compound)compounds.get(i));
                currentWorkingList.addAll(duplicate);
            }
            ++i;
        }
    }

    protected List<Sequence<T>> workingListToSequences(List<List<T>> workingList) {
        ArrayList<Sequence<T>> sequences = new ArrayList<Sequence<T>>();
        for (List<T> seqList : workingList) {
            sequences.add(this.getCreator().getSequence(seqList));
        }
        return sequences;
    }

    private List<List<T>> duplicateList(List<List<T>> incoming) {
        ArrayList<List<T>> outgoing = new ArrayList<List<T>>();
        for (List<T> current : incoming) {
            outgoing.add(new ArrayList<T>(current));
        }
        return outgoing;
    }

    protected void addCompoundToLists(List<List<T>> list, T compound) {
        if (list.isEmpty()) {
            list.add(new ArrayList());
        }
        for (List<T> current : list) {
            current.add(compound);
        }
    }

    @Override
    public Sequence<T> createSequence(Sequence<F> originalSequence) {
        List<Sequence<T>> sequences = this.createSequences(originalSequence);
        if (sequences.size() > 1) {
            throw new TranslationException("Too many sequences created; createSequence() assumes only one sequence can be created");
        }
        if (sequences.isEmpty()) {
            throw new TranslationException("No sequences created");
        }
        return (Sequence)sequences.iterator().next();
    }
}

