/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.util.zip.Checksum;

public class CRC64Checksum
implements Checksum {
    private static final long POLY64 = -2882303761517117440L;
    private static final long[] crcTable = new long[256];
    private long crc;

    static {
        int i = 0;
        while (i < 256) {
            long part = i;
            int j = 0;
            while (j < 8) {
                part = (part & 1L) != 0L ? part >>> 1 ^ 0xD800000000000000L : part >>> 1;
                ++j;
            }
            CRC64Checksum.crcTable[i] = part;
            ++i;
        }
    }

    @Override
    public void update(int b) {
        long low = this.crc >>> 8;
        long high = crcTable[(int)((this.crc ^ (long)b) & 0xFFL)];
        this.crc = low ^ high;
    }

    @Override
    public void update(byte[] b, int offset, int length) {
        int i = offset;
        while (i < length) {
            this.update(b[i]);
            ++i;
        }
    }

    public void update(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            this.update(s.charAt(i));
            ++i;
        }
    }

    @Override
    public long getValue() {
        return this.crc;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append(Long.toHexString(this.crc >>> 4));
        builder.append(Long.toHexString(this.crc & 0xFL));
        int i = 16 - builder.length();
        while (i > 0) {
            builder.insert(0, '0');
            --i;
        }
        return builder.toString().toUpperCase();
    }

    @Override
    public void reset() {
        this.crc = 0L;
    }
}

