/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.biojava3.core.util.SoftHashMap;

public class FlatFileCache {
    private static FlatFileCache me;
    private static SoftHashMap<String, byte[]> cache;

    static {
        cache = new SoftHashMap(0);
    }

    public static FlatFileCache getInstance() {
        if (me == null) {
            me = new FlatFileCache();
        }
        return me;
    }

    private FlatFileCache() {
    }

    public static void addToCache(String key, File fileToCache) {
        try {
            FileInputStream is = new FileInputStream(fileToCache);
            long length = fileToCache.length();
            byte[] bytes = new byte[(int)length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + fileToCache.getName());
            }
            ((InputStream)is).close();
            cache.put(key, bytes);
        }
        catch (Exception e) {
            System.err.println("error adding to cache! " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static InputStream getInputStream(String key) {
        byte[] bytes = cache.get(key);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public int size() {
        if (cache != null) {
            return cache.size();
        }
        return -1;
    }

    public void clear() {
        cache.clear();
    }

    public static void destroy() {
        me.clear();
        me = null;
    }
}

