/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.biojava3.core.util.XMLWriter;

public class PrettyXMLWriter
implements XMLWriter {
    private int indentUnit = 2;
    private PrintWriter writer;
    private boolean isOpeningTag = false;
    private boolean afterNewline = true;
    private int indent = 0;
    private Map<String, String> namespacePrefixes = new HashMap<String, String>();
    private int namespaceSeed = 0;
    private LinkedList<List<String>> namespaceBindings = new LinkedList();
    private List<String> namespacesDeclared = new ArrayList<String>();

    public PrettyXMLWriter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void declareNamespace(String nsURI, String prefixHint) throws IOException {
        if (!this.namespacePrefixes.containsKey(nsURI)) {
            if (this.isOpeningTag) {
                String prefix = this.allocPrefix(nsURI);
                this.attribute("xmlns:" + prefix, nsURI);
            } else {
                this.namespacesDeclared.add(nsURI);
            }
        }
    }

    private void handleDeclaredNamespaces() throws IOException {
        if (this.namespacesDeclared.size() == 0) {
            for (String nsURI : this.namespacesDeclared) {
                if (this.namespacePrefixes.containsKey(nsURI)) continue;
                String prefix = this.allocPrefix(nsURI);
                this.attribute("xmlns:" + prefix, nsURI);
            }
            this.namespacesDeclared.clear();
        }
    }

    protected void writeIndent() throws IOException {
        int i = 0;
        while (i < this.indent * this.indentUnit) {
            this.writer.write(32);
            ++i;
        }
    }

    private void _openTag() throws IOException {
        if (this.isOpeningTag) {
            this.writer.println('>');
            this.afterNewline = true;
        }
        if (this.afterNewline) {
            this.writeIndent();
        }
        ++this.indent;
        this.isOpeningTag = true;
        this.afterNewline = false;
        this.namespaceBindings.add(null);
    }

    private String allocPrefix(String nsURI) {
        String prefix = "ns" + ++this.namespaceSeed;
        this.namespacePrefixes.put(nsURI, prefix);
        List<String> bindings = this.namespaceBindings.getLast();
        if (bindings == null) {
            bindings = new ArrayList<String>();
            this.namespaceBindings.removeLast();
            this.namespaceBindings.add(bindings);
        }
        bindings.add(nsURI);
        return prefix;
    }

    @Override
    public void openTag(String nsURI, String localName) throws IOException {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IOException("Invalid namespace URI: " + nsURI);
        }
        this._openTag();
        boolean alloced = false;
        String prefix = this.namespacePrefixes.get(nsURI);
        if (prefix == null) {
            prefix = this.allocPrefix(nsURI);
            alloced = true;
        }
        this.writer.print('<');
        this.writer.print(prefix);
        this.writer.print(':');
        this.writer.print(localName);
        if (alloced) {
            this.attribute("xmlns:" + prefix, nsURI);
        }
        this.handleDeclaredNamespaces();
    }

    @Override
    public void openTag(String qName) throws IOException {
        this._openTag();
        this.writer.print('<');
        this.writer.print(qName);
        this.handleDeclaredNamespaces();
    }

    @Override
    public void attribute(String nsURI, String localName, String value) throws IOException {
        if (!this.isOpeningTag) {
            throw new IOException("attributes must follow an openTag");
        }
        String prefix = this.namespacePrefixes.get(nsURI);
        if (prefix == null) {
            prefix = this.allocPrefix(nsURI);
            this.attribute("xmlns:" + prefix, nsURI);
        }
        this.writer.print(' ');
        this.writer.print(prefix);
        this.writer.print(':');
        this.writer.print(localName);
        this.writer.print("=\"");
        this.printAttributeValue(value);
        this.writer.print('\"');
    }

    @Override
    public void attribute(String qName, String value) throws IOException {
        if (!this.isOpeningTag) {
            throw new IOException("attributes must follow an openTag");
        }
        this.writer.print(' ');
        this.writer.print(qName);
        this.writer.print("=\"");
        this.printAttributeValue(value);
        this.writer.print('\"');
    }

    private void _closeTag() {
        this.isOpeningTag = false;
        this.afterNewline = true;
        List<String> hereBindings = this.namespaceBindings.removeLast();
        if (hereBindings != null) {
            Iterator<String> bi = hereBindings.iterator();
            while (bi.hasNext()) {
                this.namespacePrefixes.remove(bi.next());
            }
        }
    }

    @Override
    public void closeTag(String nsURI, String localName) throws IOException {
        String prefix = this.namespacePrefixes.get(nsURI);
        if (prefix == null) {
            throw new IOException("Assertion failed: unknown namespace when closing tag");
        }
        --this.indent;
        if (this.isOpeningTag) {
            this.writer.println(" />");
        } else {
            if (this.afterNewline) {
                this.writeIndent();
            }
            this.writer.print("</");
            this.writer.print(prefix);
            this.writer.print(':');
            this.writer.print(localName);
            this.writer.println('>');
        }
        this._closeTag();
    }

    @Override
    public void closeTag(String qName) throws IOException {
        --this.indent;
        if (this.isOpeningTag) {
            this.writer.println(" />");
        } else {
            if (this.afterNewline) {
                this.writeIndent();
            }
            this.writer.print("</");
            this.writer.print(qName);
            this.writer.println('>');
        }
        this._closeTag();
    }

    @Override
    public void println(String data) throws IOException {
        if (this.isOpeningTag) {
            this.writer.println('>');
            this.isOpeningTag = false;
        }
        this.printChars(data);
        this.writer.println();
        this.afterNewline = true;
    }

    @Override
    public void print(String data) throws IOException {
        if (this.isOpeningTag) {
            this.writer.print('>');
            this.isOpeningTag = false;
        }
        this.printChars(data);
        this.afterNewline = false;
    }

    @Override
    public void printRaw(String data) throws IOException {
        this.writer.println(data);
    }

    protected void printChars(String data) throws IOException {
        if (data == null) {
            this.printChars("null");
            return;
        }
        int pos = 0;
        while (pos < data.length()) {
            char c = data.charAt(pos);
            if (c == '<' || c == '>' || c == '&') {
                this.numericalEntity(c);
            } else {
                this.writer.write(c);
            }
            ++pos;
        }
    }

    protected void printAttributeValue(String data) throws IOException {
        if (data == null) {
            this.printAttributeValue("null");
            return;
        }
        int pos = 0;
        while (pos < data.length()) {
            char c = data.charAt(pos);
            if (c == '<' || c == '>' || c == '&' || c == '\"') {
                this.numericalEntity(c);
            } else {
                this.writer.write(c);
            }
            ++pos;
        }
    }

    protected void numericalEntity(char c) throws IOException {
        this.writer.print("&#");
        this.writer.print((int)c);
        this.writer.print(';');
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

