/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.genome.parsers.gff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.genome.parsers.gff.FeatureI;
import org.biojava3.genome.parsers.gff.Location;

public class FeatureList_old
extends ArrayList<FeatureI> {
    Location mLocation = null;

    public FeatureList_old() {
    }

    public FeatureList_old(Collection<FeatureI> features) {
        super(features);
    }

    @Override
    public boolean add(FeatureI feature) {
        if (this.mLocation == null) {
            this.mLocation = feature.location().plus();
        } else if (feature.location() != null) {
            this.mLocation = this.mLocation.union(feature.location().plus());
        }
        return super.add(feature);
    }

    public void add(Collection<FeatureI> list) {
        for (FeatureI f : list) {
            this.add(f);
        }
    }

    public Location bounds() {
        return this.mLocation;
    }

    public boolean hasGaps(int gapLength) {
        Location last = null;
        for (FeatureI f : this) {
            if (last != null && gapLength <= f.location().distance(last)) {
                return true;
            }
            last = f.location();
        }
        return false;
    }

    public String splice(DNASequence sequence) {
        String subData = "";
        Location last = null;
        for (FeatureI f : this) {
            Location loc = f.location();
            if (last == null || loc.startsAfter(last)) {
                subData = String.valueOf(subData) + sequence.getSubSequence(loc.start(), loc.end()).toString();
                last = loc;
                continue;
            }
            throw new IllegalStateException("Splice: Feature locations should not overlap.");
        }
        return subData;
    }

    public Collection<String> groupValues() {
        LinkedHashMap hash = new LinkedHashMap();
        for (FeatureI f : this) {
            hash.put(f.group(), null);
        }
        return hash.keySet();
    }

    public Collection<String> attributeValues(String key) {
        LinkedHashMap hash = new LinkedHashMap();
        for (FeatureI f : this) {
            hash.put(f.getAttribute(key), null);
        }
        return hash.keySet();
    }

    public FeatureList_old selectByGroup(String groupid) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI f : this) {
            if (!f.group().equals(groupid)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList_old selectByType(String type) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI f : this) {
            if (!f.type().equals(type)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList_old selectByAttribute(String key, String value) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI f : this) {
            if (!f.hasAttribute(key, value)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList_old selectByAttribute(String key) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI f : this) {
            if (!f.hasAttribute(key)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList_old selectByUserData(String key, Object value) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI f : this) {
            String o = f.userData().get(key);
            if (o == null || !o.equals(value)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList_old selectByUserData(String key) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI f : this) {
            if (!f.userData().containsKey(key)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList_old selectOverlapping(String seqname, Location location, boolean useBothStrands) throws Exception {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI feature : this) {
            boolean overlaps = false;
            if (feature.seqname().equals(seqname)) {
                if (location.isSameStrand(feature.location())) {
                    overlaps = feature.location().overlaps(location);
                } else if (useBothStrands) {
                    overlaps = feature.location().overlaps(location.opposite());
                }
            }
            if (!overlaps) continue;
            list.add(feature);
        }
        return list;
    }

    public FeatureList_old omitOverlapping(String seqname, Location location, boolean useBothStrands) {
        FeatureList_old list = new FeatureList_old();
        for (FeatureI feature : this) {
            boolean overlaps = false;
            if (feature.seqname().equals(seqname)) {
                if (location.isSameStrand(feature.location())) {
                    overlaps = feature.location().overlaps(location);
                } else if (useBothStrands) {
                    overlaps = feature.location().overlaps(location.opposite());
                }
            }
            if (overlaps) continue;
            list.add(feature);
        }
        return list;
    }

    public boolean hasAttribute(String key) {
        for (FeatureI f : this) {
            if (!f.hasAttribute(key)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(String key, String value) {
        for (FeatureI f : this) {
            if (!f.hasAttribute(key, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        String s = "FeatureList: >>\n";
        for (FeatureI f : this) {
            s = String.valueOf(s) + f.seqname() + ":" + f.toString() + "\n";
        }
        return String.valueOf(s) + "\n<<\n";
    }

    public FeatureList_old sortByStart() {
        FeatureI[] array = this.toArray(new FeatureI[1]);
        Arrays.sort(array, new FeatureComparator());
        return new FeatureList_old((Collection<FeatureI>)Arrays.asList(array));
    }

    public static void main(String[] args) {
    }

    private class FeatureComparator
    implements Comparator<FeatureI> {
        private FeatureComparator() {
        }

        @Override
        public int compare(FeatureI a, FeatureI b) {
            if (a.seqname().equals(b.seqname()) && a.location().isSameStrand(b.location())) {
                return a.location().start() - b.location().start();
            }
            throw new IndexOutOfBoundsException("Cannot compare/sort features whose locations are on opposite strands or with different seqname().\r\n" + a.toString() + "\r\n" + b.toString());
        }
    }
}

