/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.biojava3.genome.parsers.gff.Feature;
import org.biojava3.genome.parsers.gff.FeatureI;
import org.biojava3.genome.parsers.gff.FeatureList;
import org.biojava3.genome.parsers.gff.Location;

public class GeneMarkGTFReader {
    private static final Logger log = Logger.getLogger(GeneMarkGTFReader.class.getName());

    public static FeatureList read(String filename) throws IOException {
        log.info("Gff.read(): Reading " + filename);
        FeatureList features = new FeatureList();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String s = br.readLine();
        while (s != null) {
            Feature f;
            if ((s = s.trim()).length() > 0 && s.charAt(0) != '#' && (f = GeneMarkGTFReader.parseLine(s)) != null) {
                features.add(f);
            }
            s = br.readLine();
        }
        br.close();
        return features;
    }

    private static Feature parseLine(String s) {
        int frame;
        Double score;
        int end;
        int start = 0;
        start = end = 0;
        end = s.indexOf(9, start);
        String seqname = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String source = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String type = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locStart = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locEnd = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            score = Double.parseDouble(s.substring(start, end));
        }
        catch (Exception e) {
            score = 0.0;
        }
        start = end + 1;
        end = s.indexOf(9, start);
        char strand = s.charAt(end - 1);
        Location location = Location.fromBio(Integer.parseInt(locStart), Integer.parseInt(locEnd), strand);
        assert (strand == '-' == location.isNegative());
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            frame = Integer.parseInt(s.substring(start, end));
        }
        catch (Exception e) {
            frame = -1;
        }
        start = end + 1;
        end = s.indexOf(35, start);
        String attributes = null;
        attributes = end < 0 ? new String(s.substring(start)) : new String(s.substring(start, end));
        return new Feature(seqname, source, type, location, score, frame, attributes);
    }

    public static void main(String[] args) throws Exception {
        FeatureList listGenes = GeneMarkGTFReader.read("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/genemark_hmm.gtf");
        System.out.println("Features");
        for (FeatureI feature : listGenes) {
            System.out.println(feature);
        }
    }
}

