#include <gtest/gtest.h>

#include <thread>

#include "cpputils/cpputils.h"

namespace utils = cpputils;

TEST (testSinkStdout,
      testLogOperator)
{
	utils::SinkStdout sink;
	std::stringstream      buffer;
	std::streambuf         * sbuf;
	std::string            testText = "Hello world";

	// Redirect std::cout to a proper buffer.
	sbuf = std::cout.rdbuf();
	std::cout.rdbuf(buffer.rdbuf());

	// Test procedure.
	sink << testText;
	ASSERT_EQ(buffer.str(),
	          testText);
	std::cout.rdbuf(sbuf);
}
