#include <gtest/gtest.h>

#include <thread>

#include "cpputilities/cpputilities.h"

namespace utils = cpputilities;

TEST (testChronometer,
      testElapsed)
{
	utils::Chronometer<> timer;
	uint64_t             testSleep = 1000;

	timer.start();
	std::this_thread::sleep_for(std::chrono::milliseconds(testSleep));
	timer.stop();
	ASSERT_EQ(timer.elapsed(),
	          testSleep);
}
